unit ddunit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    ListBox2: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure ListBoxDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListBoxDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ListBoxClick(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormCreate(Sender: TObject);
var i:integer;
begin
  //Mindkt lista fogd s vidd tulajdonsg
  listbox1.dragmode:=dmAutomatic;
  listbox2.dragmode:=dmAutomatic;
  //A listk feltltse
  For i:=1 to 9 do
    listbox1.items.add('Adat'+inttostr(i));
end;

procedure TForm1.ListBoxDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  //Mindkt ablakon az tvitel kezelse ha mozgatott elem
  if (TListBox(source).Itemindex<0) then
      TListBox(source).dragcursor:=crNoDrop;
end;

procedure TForm1.ListBoxDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
   //Mindkt ablakon az ledobs kezelse ha mozgatott elem
   if (TListBox(source).Itemindex>-1) then
     begin
       TListBox(sender).Items.Add(TListBox(source).items[TListBox(source).Itemindex]);
       TListBox(source).items.Delete(TListBox(source).Itemindex);
     end;
end;

procedure TForm1.ListBoxClick(Sender: TObject);
begin
   //Ha nincs kivlasztott elem, azt nem lehet mozgatni
   if TListBox(Sender).Itemindex>-1 then
       TListBox(Sender).dragcursor:=crDrag;
end;


end.
